within AixLib.DataBase.Media.Refrigerants.R134a;
record TSP_IIR_P1_395_T233_370
  "Record with fitting coefficients calculated for first implementation"
  extends
    AixLib.DataBase.Media.Refrigerants.ThermodynamicStatePropertiesBaseDataDefinition(
    name="Coefficients taken from Engelpracht",
    T_phNt={4, 9, 40,
            4, 9, 40},
    Tl_phA={0.0532548969281581, -0.0327402932674217,
            0.00529495748475652, -0.0147899438674052},
    Tl_phB={59.7998195834653, -6.62177534265252,
            -2.9999979725331, 1.18395227550521,
            2.80248047103141, -2.62761643515741,
            -3.56947078020548, 0.491461507071165,
            0.927463043044066},
    Tl_phC={-1.19878518364951, -0.962577907835024,
            0.878481585133851, 3.91182176711109,
            1.04265487024909, -0.48195831147019,
            3.9963905002665, -1.69733815644078,
            -0.731437549563384, 0.0770329850582095,
            -1.83698529629045, -2.43696481656084,
            0.468070335493652, 0.181462921419216,
            -1.82312663184436, -0.0230311877679581,
            0.982708752218969, 0.0536451024965748,
            1.14817103067673, 0.640727250560578,
            0.128969357549004, -0.134539808379163,
            1.23170727519629, 0.0597699698084911,
            -0.129555670548255, -0.0975402807270774},
    Tl_phD={314.827695408612},
    Tv_phA={19.7159455145757, -0.349661716358068,
            -0.0779836049824056, -0.0404894448559818},
    Tv_phB={44.9076643959871, 1.61226716995587,
            -1.69537088625365, 1.26072555204728,
            -0.567008612580563, 0.0701057832233571,
            0.0254180887275049, -0.0124041988508943,
            0.0028610409309618},
    Tv_phC={-0.00106840793875426, 0.0416365945399298,
            -0.0195802880749286, -0.179660544834243,
            -0.076962508011698, 0.0509650798466933,
            -0.00279310782986392, 0.617814317683068,
            -0.0790534022062859, -0.0468161156252338,
            1.14842192548223, -0.919924069116996,
            -0.322612907855446, 0.169304169481087,
            -2.53676746445355, 0.126032916849538,
            0.683339136223397, -0.12360236699935,
            4.44394813815231, 0.335016787119797,
            -0.246814891775665, -0.113020154572386,
            -10.1366697046488, 0.120870986010151,
            -0.0231738848883972, 0.136566349184184},
    Tv_phD={363.221803450648},
    T_phIO={3258359.21215142,1352817.03780238,
             258541.38494292, 87545.3330013087, 0, 1,
             1623982.43177388, 1517145.25710131,
             464371.882231745, 51004.186742787, 0, 1},
    T_psNt={4, 10, 45,
            4, 10, 45},
    Tl_psA={0.94996237530845, 0.303157516353388,
            0.0425905424516415, -0.00612110456282157},
    Tl_psB={52.1272715438709, 0.934991565642564,
            -1.66612434799561, -1.27792380300538,
            0.410987961018363, 1.20370954075399,
            -0.533205810766702, -1.00320676865041,
            0.0173571141739969, 0.180140992292161},
    Tl_psC={-0.291069659186083, -0.0872169090380506,
            0.210931565927688, 1.54473840594432,
            0.242658047959267, -0.125471470126885,
            1.27724167635143, -0.749529598236941,
            -0.260793835526211, 0.0285723567918958,
            -1.20931903922332, -1.20679390142769,
            0.14579825633924, 0.0761667567718539,
            -0.980601828987551, -0.0414786123544972,
            0.67239714034787, 0.0115047530756927,
            0.633536586430794, 0.603963042415619,
            0.449251036040618, -0.143342451130932,
            0.739997965709238, 0.284571979372862,
            0.00615406154781733, -0.170430522133426,
            0.674829627189691, 0.191394330126145,
            -0.041146019162364, -0.0717852001683681},
    Tl_psD={300.587264376628},
    Tv_psA={40.390945841519, 3.15200862940067,
            0.84009020654906, 0.177443077694145},
    Tv_psB={39.8941858976051, 2.0764693478832,
            -0.364336953952206, 0.0421908648150418,
            0.0677619152714318, -0.0204430553521217,
            -0.0190222016179443, 0.0122643123754593,
            -0.00234908647943673, 0.00012413799291331},
    Tv_psC={-0.00140522490504156, 0.00329122730110688,
            -0.00937491577006562, 0.0333827070862789,
            0.0508721324649598, -0.0216247475662101,
            -0.148892361231698, -0.0330211687434747,
            0.122997152293476, -0.023644132786541,
            0.160671867686228, -0.256585546262645,
            -0.210848453821976, 0.131206121652008,
            0.102631340846465, 0.499615855820928,
            0.0559247407428316, -0.207112807377818,
            -0.320168181386132, -0.147739984347582,
            0.113844709544168, 0.0165765359506585,
            0.588939883715035, 0.00902349232653274,
            0.0295039397995595, 0.146603156395031,
            -0.434825078991382, -0.932894048645235,
            -0.34837692742088, -0.0914682411901647},
    Tv_psD={327.5152079225},
    T_psIO={14.7875365886205,0.663511063673611,
            1126.31192475932, 244.853512874793, 0, 1,
            13.204266881401, 1.16895892611495,
            1831.0596916082, 116.879525072462, 0, 1},
    d_pTNt={3, 12, 46,
            18, 4, 85},
    dl_pTA={7.87433412548864, -0.393021216688428,
            -0.0297809665090564},
    dl_pTB={-152.964391932951, -26.5844725397398,
             -13.2573880132147, 8.42443025706179,
            14.2596863645139, -18.3785897660491,
            -24.8669510003648, 7.78387180871463,
            15.7146697953855, 0.681093877003925,
            -3.80893784483356, -1.02415118562434},
    dl_pTC={2.06494548963484, 7.57753444222479,
            -1.26044732839976, 0.305045780960498,
            -5.16251152860913, 0.227139340077688,
            -24.4943337560739, -2.88562398358126,
            1.13671327198115, -14.5056545529004,
            11.723519090061, 1.48106761398927,
            28.7134548150431, 12.5950803196686,
            -1.02019713556307, 22.307603797593,
            -8.24807441103373, -3.24960897757928,
            -10.5027246393796, -12.0818129588016,
            -0.922165432363117, -6.49123842323816,
            0.746728622500784, 1.59789449316334,
            5.70882420483716, 2.56319794925055,
            0.824892590067656, 7.146645111271,
            -0.411530121945932, -0.0588201589015566},
    dl_pTD={1189.94427795653},
    dv_pTA={63.4239308958369, 18.3003263667046,
            9.39421881473955, 7.09177356543309,
            5.23708459011804, 0.578782340741552,
            -1.54042394843668, 1.25422245124727,
            3.20297513437295, 2.27421493369135,
            -0.504581868379304, -1.12599416061308,
            1.55331005888042, 1.16161743095121,
            -1.20184737545216, -0.74648142212366,
            0.278070675613861, 0.1689335064038},
    dv_pTB={-12.4136441424452, 3.88226290732021,
            -1.70439246480624, 0.562626262975482},
    dv_pTC={-1.17017884482496, -2.3852489066477,
            3.06658887799103, 4.57803202704379,
            7.60586826210336, -3.6374054137502,
            11.1305887867053, -10.531890937117,
            -10.6025332817454, 1.67395801589396,
            -4.11656519288863, -37.829721696342,
            10.8160047767693, 5.39724210896898,
            -15.8509141937486, 0.16539060896887,
            56.1542951833691, -4.37751446853329,
            -0.700734627984774, 58.9914336041491,
            12.6985686213048, -30.0162045272803,
            3.29957742403242, 29.3966215270787,
            -98.1518521184536, -11.3492996193995,
            -11.3408317015857, -14.6134355681511,
            -70.1869342443377, 56.8538866067529,
            -10.8064971385458, -1.52226374447057,
            45.0040674986077, 50.1097731625293,
            2.5492410749415, 4.97951280387615,
            44.4419747118542, -34.0879999837732,
            2.67944204720335, -0.501886352998431,
            -6.26134528520153, -47.2205597266305,
            -11.7666587360995, 9.71258637652847,
            -10.6315428426648, 4.53156357787073,
            -19.9076698455612, 20.8686520295642,
            -11.5331539200892, 19.2381594479155,
            -19.3570225767985, 23.2916795123783,
            -17.0315966365249, 5.95211177024792,
            -20.0890389234895, 18.9596025990082,
            -12.5541351899702, 1.61845307417717,
            -20.9996689026322, 11.4012827945148,
            -6.08216841759289, 1.6139077221972},
    dv_pTD={73.118571695972},
    d_pTIO={3067141.02087822,1250016.64160742,
            306.333739723678, 39.7052211222868, 0, 1.007596524,
            1600766.20840426, 1019029.80447803,
            345.780142922559, 24.3460840999553, 0, 0.999});

  annotation (Documentation(revisions="<html>
<ul>
  <li>
  June 14, 2017, by Mirko Engelpracht, Christian Vering:<br/>
  First implementation
  (see <a href=\"https://github.com/RWTH-EBC/AixLib/issues/408\">issue 408</a>).
  </li>
</ul>
</html>", info="<html>
<p>
In this record, fitting coefficients are provided for thermodynamic properties
calculated from two independent state variables. For detailed information of
these thermodynamic properties as well as the fitting coefficients, please
checkout
<a href=\"modelica://AixLib.DataBase.Media.Refrigerants.ThermodynamicStatePropertiesBaseDataDefinition\">
AixLib.DataBase.Media.Refrigerants.ThermodynamicStatePropertiesBaseDataDefinition
</a>.
The fitting coefficients are used in a hybrid refrigerant model provided in
<a href=\"modelica://AixLib.Media.Refrigerants\">AixLib.Media.Refrigerants</a>.
For detailed information, please checkout
<a href=\"modelica://AixLib.Media.Refrigerants.Interfaces.TemplateHybridTwoPhaseMediumRecord\">
AixLib.Media.Refrigerants.Interfaces.TemplateHybridTwoPhaseMediumRecord</a>.
</p>
<h4>Assumptions and limitations</h4>
<p>
The provided coefficients are fitted to external data by Engelpracht and are
valid within the following range:<br />
</p>
<table summary=\"Range of validiry\" cellspacing=\"0\" cellpadding=\"2\"
border=\"1\" width=\"30%\" style=\"border-collapse:collapse;\">
<tr>
  <td><p>Parameter</p></td>
  <td><p>Minimum Value</p></td>
  <td><p>Maximum Value</p></td>
</tr>
<tr>
  <td><p>Pressure (p) in bar</p></td>
  <td><p>1</p></td>
  <td><p>39.5</p></td>
</tr>
<tr>
  <td><p>Temperature (T) in K</p></td>
  <td><p>233.15</p></td>
  <td><p>370.15</p></td>
</tr>
</table>
<p>
The reference point is defined as 200 kJ/kg and 1 kJ/kg/K, respectively, for
enthalpy and entropy for the saturated liquid at 273.15 K.
</p>
<h4>References</h4>
<p>
Engelpracht, Mirko (2017): Development of modular and scalable simulation
models for heat pumps and chillers considering various refrigerants.
<i>Master Thesis</i>
</p>
</html>"));
end TSP_IIR_P1_395_T233_370;
